-- MySQL dump 10.13  Distrib 5.5.60, for debian-linux-gnu (x86_64)
--
-- Host: localhost    Database: logisystem_vente_syssi
-- ------------------------------------------------------
-- Server version	5.5.60-0+deb7u1

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `logisystem_vente_syssi`
--


--
-- Table structure for table `acces_membres`
--

DROP TABLE IF EXISTS `acces_membres`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `acces_membres` (
  `id_membre` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `role` int(1) unsigned zerofill DEFAULT NULL,
  `nom_utilisateur` varchar(32) NOT NULL,
  `mot_de_passe` char(60) NOT NULL,
  `hash_validation` char(32) NOT NULL,
  `date_inscription` date NOT NULL,
  `derniere_date_log` datetime NOT NULL,
  `ip` varchar(15) NOT NULL,
  `hostname` varchar(60) NOT NULL,
  PRIMARY KEY (`id_membre`),
  UNIQUE KEY `nom_utilisateur` (`nom_utilisateur`),
  KEY `mot_de_passe` (`mot_de_passe`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `acces_membres`
--

LOCK TABLES `acces_membres` WRITE;
/*!40000 ALTER TABLE `acces_membres` DISABLE KEYS */;
INSERT INTO `acces_membres` VALUES (1,1,'bingojm','$2y$13$ub87Fl9bXsxOnNwmB2y8geHLSoZITxSZz6ETnpWf.fZ.rP2qlAgYm','','2017-08-15','2020-03-25 08:49:03','213.211.142.148','213.211.142.148.dyn.edpnet.net'),(2,2,'admin','$2y$13$32JlZuQNHqWICOMOpnvtRO9RClCfcT0aI5PbsQZx/eaZRqPkSY.2y','','2019-12-18','0000-00-00 00:00:00','',''),(3,3,'syssi','$2y$13$32JlZuQNHqWICOMOpnvtRO9RClCfcT0aI5PbsQZx/eaZRqPkSY.2y','','2019-12-18','2021-02-05 15:04:29','109.132.141.41','41.141-132-109.adsl-dyn.isp.belgacom.be'),(4,4,'compta_bak','','','2017-12-26','2019-12-08 18:56:04','81.242.108.11','11.108-242-81.adsl-dyn.isp.belgacom.be');
/*!40000 ALTER TABLE `acces_membres` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `clients`
--

DROP TABLE IF EXISTS `clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `clients` (
  `id_client` smallint(5) NOT NULL AUTO_INCREMENT,
  `societe` varchar(40) NOT NULL,
  `tva` varchar(12) NOT NULL,
  `sexe` tinyint(1) unsigned NOT NULL,
  `nom` varchar(50) NOT NULL,
  `prenom` varchar(20) NOT NULL,
  `rue` varchar(50) NOT NULL,
  `num` varchar(5) NOT NULL,
  `boite` varchar(5) NOT NULL,
  `code_postal` smallint(5) unsigned NOT NULL,
  `ville` varchar(20) NOT NULL,
  `tel` int(9) unsigned zerofill NOT NULL,
  `gsm` int(10) unsigned zerofill NOT NULL,
  `date_naissance` date NOT NULL,
  `email` varchar(50) NOT NULL,
  `remise` tinyint(1) unsigned NOT NULL,
  `remise_fidelite` float unsigned NOT NULL,
  `remise_pourcent` smallint(2) unsigned NOT NULL,
  `date_enregistrement` datetime NOT NULL,
  `infos_supp` text NOT NULL,
  `message_important` text NOT NULL,
  `statut` tinyint(1) unsigned NOT NULL,
  PRIMARY KEY (`id_client`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `clients`
--

LOCK TABLES `clients` WRITE;
/*!40000 ALTER TABLE `clients` DISABLE KEYS */;
INSERT INTO `clients` VALUES (1,'','',1,'ANONYME','ANONYME','','','',0,'',000000000,0000000000,'0000-00-00','',2,0,0,'2016-12-28 10:37:24','','',1),(2,'','',1,'DIEUDONNE','Jean-Michel','','','',0,'',000000000,0478907104,'1983-08-06','',1,0.5,0,'2019-12-18 15:50:55','','',1),(3,'','',1,'DUBOIS','Patricia','','','',0,'',000000000,0000000000,'1965-08-10','',2,0,5,'2019-12-18 16:02:11','','',1),(4,'','',1,'DUMONT','André','Rue des tanneries ','3','',6980,'La Roche en ardenne',000000000,0000000486,'1964-09-22','dumont.andre.64@gmail.com',2,0,20,'2019-12-18 16:54:19','','',1),(5,'','',2,'WATHY','Bénédicte ','Route de Beffe','25','6997 ',0,'',000000000,0000000049,'0000-00-00','benewathy@hotmail.com',1,0.5,0,'2019-12-19 12:02:06','','',1),(6,'','',2,'CARPE','Martine','Quai de l\'outhe','2','1',6980,'La Roche en ardenne',000000000,0470173222,'0000-00-00','',1,0.5,0,'2019-12-19 12:20:10','','',1),(7,'','',2,'ROBAYE','Pascale','Chaussée Roosevelt','179','5',4540,'Amay',000000000,0472104632,'0000-00-00','pascalethiebaut0@gmail.com',1,0.5,0,'2019-12-19 15:02:39','Fille de Liliane Lambert','',1),(8,'','',2,'Clarens','Vinciane','Avenue de Villez','29','b',6980,'La Roche en ardenne',000000000,0477299526,'0000-00-00','clarensvinciane@hotmail.com',1,0.5,0,'2020-01-04 15:26:41','','',1),(9,'','',2,'Clarens','Vinciane','Avenue de Villez','29','b',6980,'La Roche en ardenne',000000000,0477299526,'0000-00-00','clarensvinciane@hotmail.com',1,0.5,0,'2020-01-04 15:26:42','','',1),(10,'','',2,'Clarens','Vinciane','Avenue de Villez','29','b',6980,'La Roche en ardenne',000000000,0477299526,'0000-00-00','clarensvinciane@hotmail.com',1,0.5,0,'2020-01-04 15:26:52','','',1);
/*!40000 ALTER TABLE `clients` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `factures_liste`
--

DROP TABLE IF EXISTS `factures_liste`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `factures_liste` (
  `id_facture` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pre_num_facture` varchar(6) NOT NULL,
  `num_facture` varchar(3) NOT NULL,
  `num_vente` int(10) unsigned NOT NULL,
  `num_commande` varchar(15) NOT NULL,
  `date` date NOT NULL,
  `heure` time NOT NULL,
  PRIMARY KEY (`id_facture`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `factures_liste`
--

LOCK TABLES `factures_liste` WRITE;
/*!40000 ALTER TABLE `factures_liste` DISABLE KEYS */;
/*!40000 ALTER TABLE `factures_liste` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fidelite_points`
--

DROP TABLE IF EXISTS `fidelite_points`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fidelite_points` (
  `id_fidelite_points` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_client` smallint(5) unsigned NOT NULL,
  `points` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY (`id_fidelite_points`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fidelite_points`
--

LOCK TABLES `fidelite_points` WRITE;
/*!40000 ALTER TABLE `fidelite_points` DISABLE KEYS */;
/*!40000 ALTER TABLE `fidelite_points` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nc_liste`
--

DROP TABLE IF EXISTS `nc_liste`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nc_liste` (
  `id_nc` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pre_num_nc` varchar(6) NOT NULL,
  `num_nc` varchar(3) NOT NULL,
  `num_vente` int(10) unsigned NOT NULL,
  `action` tinyint(1) NOT NULL,
  `date` date NOT NULL,
  `heure` time NOT NULL,
  PRIMARY KEY (`id_nc`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nc_liste`
--

LOCK TABLES `nc_liste` WRITE;
/*!40000 ALTER TABLE `nc_liste` DISABLE KEYS */;
/*!40000 ALTER TABLE `nc_liste` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `paiements`
--

DROP TABLE IF EXISTS `paiements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `paiements` (
  `id_paiement` tinyint(2) unsigned NOT NULL AUTO_INCREMENT,
  `moyen` varchar(20) NOT NULL,
  PRIMARY KEY (`id_paiement`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `paiements`
--

LOCK TABLES `paiements` WRITE;
/*!40000 ALTER TABLE `paiements` DISABLE KEYS */;
INSERT INTO `paiements` VALUES (1,'Espèces'),(2,'Bancontact'),(3,'Carte de crédit'),(4,'Virement');
/*!40000 ALTER TABLE `paiements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `personnel`
--

DROP TABLE IF EXISTS `personnel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `personnel` (
  `id_personnel` tinyint(3) NOT NULL AUTO_INCREMENT,
  `nom` varchar(25) NOT NULL,
  `prenom` varchar(25) NOT NULL,
  PRIMARY KEY (`id_personnel`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `personnel`
--

LOCK TABLES `personnel` WRITE;
/*!40000 ALTER TABLE `personnel` DISABLE KEYS */;
INSERT INTO `personnel` VALUES (1,'MARS','Sylviane');
/*!40000 ALTER TABLE `personnel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `produits`
--

DROP TABLE IF EXISTS `produits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `produits` (
  `id_produit` smallint(5) NOT NULL AUTO_INCREMENT,
  `code_produit` varchar(15) NOT NULL,
  `code_depot` varchar(15) NOT NULL,
  `libelle` varchar(60) NOT NULL,
  `prix_achat` decimal(9,2) NOT NULL,
  `prix_vente` decimal(9,2) NOT NULL,
  `code_barre` bigint(13) unsigned zerofill NOT NULL,
  `id_produits_tva` tinyint(1) unsigned NOT NULL,
  `stock` smallint(5) NOT NULL,
  `stock_min` smallint(5) unsigned NOT NULL,
  `dernier_stock` date NOT NULL,
  `id_produits_type` smallint(5) unsigned NOT NULL,
  `id_produits_gamme` smallint(5) unsigned NOT NULL,
  `fournisseur` tinyint(3) unsigned NOT NULL,
  `statut` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id_produit`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `produits`
--

LOCK TABLES `produits` WRITE;
/*!40000 ALTER TABLE `produits` DISABLE KEYS */;
INSERT INTO `produits` VALUES (1,'BCA','','Bon Cadeau - Achat',0.00,0.00,0000000000000,2,1,1,'0000-00-00',7,20,0,1),(2,'BCR','','Bon Cadeau - Retour',0.00,0.00,0000000000000,3,1,1,'0000-00-00',7,21,0,1),(6,'FLR','','Fleurs - Composition',0.00,0.00,0000000000000,2,1,1,'0000-00-00',11,25,0,1),(3,'RPT','','Réparation',0.00,0.00,0000000000000,2,1,1,'0000-00-00',8,22,0,1),(4,'BVR','','Bon de Valeur - Retour',0.00,0.00,0000000000000,3,1,1,'0000-00-00',9,23,0,1),(5,'CFR','','Carte Fidélité - Retour',0.00,0.00,0000000000000,2,1,1,'0000-00-00',10,24,0,1),(7,'100','100','Bouquet',6.00,15.00,0000000000000,1,3,1,'2020-01-20',4,5,7,1),(8,'T&T','2019/12','HORLOGE',20.00,50.00,5414451201827,2,1,0,'2020-02-01',5,10,3,1),(9,'B/10','','Bouquet',3.00,10.00,0000000000000,1,1,0,'2020-02-01',4,5,7,1),(10,'01','MF','Fleurs coupées',0.50,1.20,0000000000000,1,1,0,'2020-02-16',4,5,7,1),(11,'1000','','BALI BOUGEOIR / 1',4.50,20.00,0000000000000,2,1,0,'2021-02-04',5,6,5,1);
/*!40000 ALTER TABLE `produits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `produits_fournisseur`
--

DROP TABLE IF EXISTS `produits_fournisseur`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `produits_fournisseur` (
  `id_produits_fournisseur` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `fournisseur` varchar(40) NOT NULL,
  PRIMARY KEY (`id_produits_fournisseur`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `produits_fournisseur`
--

LOCK TABLES `produits_fournisseur` WRITE;
/*!40000 ALTER TABLE `produits_fournisseur` DISABLE KEYS */;
INSERT INTO `produits_fournisseur` VALUES (1,'HOEKFLOWERS'),(2,'EBUS'),(3,'TRADE &TRADE DECO'),(4,'TRADE &TRADE FASHION'),(5,'EKLECTICK ASIA'),(6,'SAVONNERIE DE NYON'),(7,'MULTIFLEURS'),(8,'AVA'),(9,'BRICO'),(10,'SPRL LENGLER'),(11,'DESTREE');
/*!40000 ALTER TABLE `produits_fournisseur` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `produits_gamme`
--

DROP TABLE IF EXISTS `produits_gamme`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `produits_gamme` (
  `id_produits_gamme` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `gamme` varchar(35) NOT NULL,
  `id_produits_type` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`id_produits_gamme`)
) ENGINE=MyISAM AUTO_INCREMENT=20 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `produits_gamme`
--

LOCK TABLES `produits_gamme` WRITE;
/*!40000 ALTER TABLE `produits_gamme` DISABLE KEYS */;
INSERT INTO `produits_gamme` VALUES (6,'Bougeoir Bois Flotté',5),(7,'Cadre texte',5),(8,'Coupe verre et bois flotté',5),(9,'Déco Bois Flotté',5),(10,'Horloge',5),(11,'Luminaire',5),(12,'Cache-pot',4),(13,'Composition',4),(14,'Orchidée',4),(15,'Bijoux',6),(16,'Bougie parfumée',6),(17,'Parfum',6),(18,'Sac',6),(19,'Savon',6),(1,'Achat',1),(2,'Retour',1),(3,'Bon de valeur',2),(4,'Carte de fidélité',3),(5,'Fleurs - Composition',4);
/*!40000 ALTER TABLE `produits_gamme` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `produits_stock_mvts`
--

DROP TABLE IF EXISTS `produits_stock_mvts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `produits_stock_mvts` (
  `id_produits_stock_mvts` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_produit` smallint(5) unsigned NOT NULL,
  `date_mvt` datetime NOT NULL,
  `date_dernier_stock` date NOT NULL,
  `ancien_stock` smallint(5) NOT NULL,
  `quantite` smallint(5) NOT NULL,
  `nouveau_stock` smallint(5) NOT NULL,
  `ajout_retrait` varchar(7) NOT NULL,
  `raison` varchar(200) NOT NULL,
  PRIMARY KEY (`id_produits_stock_mvts`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `produits_stock_mvts`
--

LOCK TABLES `produits_stock_mvts` WRITE;
/*!40000 ALTER TABLE `produits_stock_mvts` DISABLE KEYS */;
INSERT INTO `produits_stock_mvts` VALUES (1,7,'2020-01-20 11:11:29','0000-00-00',0,3,3,'Ajout','Nouvel article'),(2,8,'2020-02-01 13:57:53','0000-00-00',0,1,1,'Ajout','Nouvel article'),(3,9,'2020-02-01 14:04:11','0000-00-00',0,1,1,'Ajout','Nouvel article'),(4,10,'2020-02-16 12:04:51','0000-00-00',0,1,1,'Ajout','Nouvel article'),(5,11,'2021-02-04 18:26:34','0000-00-00',0,1,1,'Ajout','Nouvel article');
/*!40000 ALTER TABLE `produits_stock_mvts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `produits_tva`
--

DROP TABLE IF EXISTS `produits_tva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `produits_tva` (
  `id_produits_tva` tinyint(1) unsigned NOT NULL AUTO_INCREMENT,
  `tva` int(3) NOT NULL,
  PRIMARY KEY (`id_produits_tva`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `produits_tva`
--

LOCK TABLES `produits_tva` WRITE;
/*!40000 ALTER TABLE `produits_tva` DISABLE KEYS */;
INSERT INTO `produits_tva` VALUES (1,6),(2,21),(3,0);
/*!40000 ALTER TABLE `produits_tva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `produits_type`
--

DROP TABLE IF EXISTS `produits_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `produits_type` (
  `id_produits_type` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(50) NOT NULL,
  PRIMARY KEY (`id_produits_type`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `produits_type`
--

LOCK TABLES `produits_type` WRITE;
/*!40000 ALTER TABLE `produits_type` DISABLE KEYS */;
INSERT INTO `produits_type` VALUES (1,'Bon cadeau'),(2,'Bon de valeur'),(3,'Carte de fidélité'),(4,'Fleurs - Composition'),(5,'Décorations'),(6,'Accessoires');
/*!40000 ALTER TABLE `produits_type` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ventes`
--

DROP TABLE IF EXISTS `ventes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ventes` (
  `id_vente` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `num_vente` int(10) unsigned NOT NULL,
  `id_produit` smallint(5) unsigned NOT NULL,
  `code_produit` varchar(15) NOT NULL,
  `code_depot` varchar(15) NOT NULL,
  `quantite` smallint(5) unsigned NOT NULL,
  `libelle` varchar(60) NOT NULL,
  `prix_unitaire` decimal(9,2) NOT NULL,
  `prix_total` decimal(9,2) NOT NULL,
  `reduction` tinyint(3) unsigned NOT NULL,
  `ristourne` decimal(9,2) NOT NULL,
  `prix_reduit` decimal(9,2) NOT NULL,
  `auteur` tinyint(2) unsigned NOT NULL,
  `type` varchar(20) NOT NULL,
  `gamme` varchar(20) NOT NULL,
  `tva` tinyint(1) unsigned NOT NULL,
  `date` date NOT NULL,
  `heure` time NOT NULL,
  `auteur_encaissement` tinyint(2) unsigned NOT NULL,
  `paiement` tinyint(2) unsigned NOT NULL,
  `total_vente_2` decimal(9,2) NOT NULL,
  `total_reduction_2` decimal(9,2) NOT NULL,
  `somme_payee` decimal(9,2) NOT NULL,
  `rendu` decimal(9,2) NOT NULL,
  `facture` tinyint(1) NOT NULL,
  `retour` tinyint(1) NOT NULL,
  `note_credit` tinyint(1) NOT NULL,
  `id_client` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`id_vente`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ventes`
--

LOCK TABLES `ventes` WRITE;
/*!40000 ALTER TABLE `ventes` DISABLE KEYS */;
/*!40000 ALTER TABLE `ventes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ventes_deleted`
--

DROP TABLE IF EXISTS `ventes_deleted`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ventes_deleted` (
  `id_vente` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `num_vente` int(10) unsigned NOT NULL,
  `id_produit` smallint(5) unsigned NOT NULL,
  `code_produit` varchar(15) NOT NULL,
  `code_depot` varchar(15) NOT NULL,
  `quantite` smallint(5) unsigned NOT NULL,
  `libelle` varchar(60) NOT NULL,
  `prix_unitaire` decimal(9,2) NOT NULL,
  `prix_total` decimal(9,2) NOT NULL,
  `reduction` tinyint(3) unsigned NOT NULL,
  `ristourne` decimal(9,2) NOT NULL,
  `prix_reduit` decimal(9,2) NOT NULL,
  `auteur` tinyint(2) unsigned NOT NULL,
  `type` varchar(20) NOT NULL,
  `gamme` varchar(20) NOT NULL,
  `tva` tinyint(1) unsigned NOT NULL,
  `date` date NOT NULL,
  `heure` time NOT NULL,
  `auteur_encaissement` tinyint(2) unsigned NOT NULL,
  `paiement` tinyint(2) unsigned NOT NULL,
  `total_vente_2` decimal(9,2) NOT NULL,
  `total_reduction_2` decimal(9,2) NOT NULL,
  `somme_payee` decimal(9,2) NOT NULL,
  `rendu` decimal(9,2) NOT NULL,
  `facture` tinyint(1) NOT NULL,
  `retour` tinyint(1) NOT NULL,
  `note_credit` tinyint(1) NOT NULL,
  `id_client` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`id_vente`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ventes_deleted`
--

LOCK TABLES `ventes_deleted` WRITE;
/*!40000 ALTER TABLE `ventes_deleted` DISABLE KEYS */;
/*!40000 ALTER TABLE `ventes_deleted` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ventes_pause`
--

DROP TABLE IF EXISTS `ventes_pause`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ventes_pause` (
  `id_vente` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `num_vente` int(10) unsigned NOT NULL,
  `id_produit` smallint(5) unsigned NOT NULL,
  `quantite` smallint(5) unsigned NOT NULL,
  `reduction` tinyint(3) unsigned NOT NULL,
  `date` date NOT NULL,
  `heure` time NOT NULL,
  `id_client` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`id_vente`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ventes_pause`
--

LOCK TABLES `ventes_pause` WRITE;
/*!40000 ALTER TABLE `ventes_pause` DISABLE KEYS */;
/*!40000 ALTER TABLE `ventes_pause` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2022-02-07 11:19:29

